------------------------------------------------------------------------------
--	FILE:	 PlayEuropeAgain.Lua
--  Hornigas
--  Imported to Civ VI by Gedemon (2016)
------------------------------------------------------------------------------

include "MapEnums"
include "MapUtilities"
include "MountainsCliffs"
include "RiversLakes"
include "FeatureGenerator"
include "TerrainGenerator"
include "NaturalWonderGenerator"
include "ResourceGenerator"
include "AssignStartingPlots"

local mapName = MapConfiguration.GetValue("MapName")
print("Loading "..tostring(mapName).." script")

local g_iW = 108
local g_iH = 98
local g_iFlags = {}
local g_continentsFrac = nil

------------------------------------------------------------------------------
-- The application side will call GetMapScriptInfo directly to request
-- information about the map script.
-------------------------------------------------------------------------------
function GetMapInitData(worldSize)
	return {
		Width = g_iW,
		Height = g_iH,
		WrapX = false,
		WrapY = false,
	};      
end

-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
function GenerateMap()
	print("Calling Map Generator");
	-- Everything has been moved to the modded AssignStartingPlots in the "override" folder, search for "YnAMP" string in that file
	GenerateImportedMap(GetMap(), GetCiv6DataToConvert(), GetNaturalWonders(), g_iW, g_iH)
end

function GetNaturalWonders()
	local NaturalWonders = {}	
		
	NaturalWonders[GameInfo.Features["FEATURE_CLIFFS_DOVER"].Index] 	= { X = 30, Y = 59}
	NaturalWonders[GameInfo.Features["FEATURE_DEAD_SEA"].Index] 		= { X = 83, Y = 10}	
	
	return NaturalWonders
end

function GetCiv6DataToConvert()
	local Civ6DataToConvert = {}
	for i = 0, g_iW - 1, 1 do
		Civ6DataToConvert[i] = {}
	end
	
	-- Civ6 Data (copy from Lua.log below and on each lines remove everything before "Civ6DataToConvert")
	-- Civ6DataToConvert[x][y]={{IsNEOfCliff,IsWOfCliff,IsNWOfCliff},}
	
	-- End of Cliffs table
	return Civ6DataToConvert
end

function GetMap()

	local MapToConvert = {}
	for i = 0, g_iW - 1, 1 do
		MapToConvert[i] = {}
	end
	
	-- Map Data
	-- MapToConvert[x][y] = {civ5TerrainType, civ5PlotTypes, civ5FeatureTypes, civ5ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ5ResourceType, num} }
	
 MapToConvert[0][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][0]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][0]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][0]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{21,1}}
 MapToConvert[75][0]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][0]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][0]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][0]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][0]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][0]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][0]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][1]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[72][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][1]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[75][1]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[76][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][1]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][1]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][1]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][1]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[85][1]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][1]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][1]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][2]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][2]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[75][2]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][2]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][2]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[80][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[84][2]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][2]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][2]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][2]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[63][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][3]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][3]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[74][3]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][3]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][3]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][3]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[85][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][3]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][3]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[61][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[66][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[72][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][4]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{21,1}}
 MapToConvert[74][4]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][4]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[77][4]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[78][4]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][4]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[84][4]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[85][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][4]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][5]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][5]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][5]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][5]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][5]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][5]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][5]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][5]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][5]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][5]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][5]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][5]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][5]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][5]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][5]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[97][5]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[98][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][5]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][6]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[73][6]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[74][6]={2,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][6]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][6]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][6]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][6]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][6]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[84][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][6]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[96][6]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][7]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][7]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[53][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[71][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][7]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][7]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][7]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[75][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][7]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][7]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][7]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][7]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][7]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][7]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][7]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][7]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][7]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][7]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][7]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][8]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][8]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][8]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][8]={0,2,-1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][8]={0,2,-1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[75][8]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][8]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][8]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[79][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][8]={1,1,19,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][8]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][8]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][8]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[86][8]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][8]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[97][8]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][8]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][8]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[2][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[52][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][9]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[55][9]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[65][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][9]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[70][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[71][9]={0,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[72][9]={0,2,-1,3,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[73][9]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][9]={0,2,-1,3,{{0,-1},{0,-1},{1,4}},{1,4}}
 MapToConvert[75][9]={0,2,-1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[76][9]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[77][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[83][9]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][9]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][9]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[95][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][9]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][9]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][9]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[107][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][10]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][10]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[7][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[42][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[50][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[51][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][10]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[56][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][10]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[66][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[68][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[69][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][10]={0,2,2,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][10]={0,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[74][10]={0,2,-1,3,{{1,5},{0,-1},{0,-1}},{6,1}}
 MapToConvert[75][10]={0,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][10]={0,2,-1,3,{{1,2},{1,0},{0,-1}},{8,1}}
 MapToConvert[77][10]={2,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][10]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[84][10]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][10]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][10]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][10]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,1}}
 MapToConvert[3][11]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][11]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][11]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][11]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][11]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][11]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[57][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][11]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[60][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[66][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[73][11]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][11]={0,2,2,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][11]={0,2,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[76][11]={0,2,2,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[77][11]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[78][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[81][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][11]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{31,1}}
 MapToConvert[83][11]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][11]={2,2,24,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][11]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][11]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][11]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[2][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[9][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[38][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][12]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][12]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][12]={1,1,5,3,{{0,-1},{1,0},{1,1}},{18,1}}
 MapToConvert[58][12]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[60][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[77][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[81][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][12]={1,1,5,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[84][12]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][12]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[107][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][13]={2,0,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[1][13]={2,0,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[2][13]={2,1,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][13]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][13]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][13]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[10][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[39][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{4,2}}
 MapToConvert[43][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[45][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[56][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][13]={0,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[58][13]={1,1,-1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[59][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[82][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][13]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[105][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][14]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][14]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[8][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][14]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[44][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[46][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[58][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[83][14]={0,1,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[84][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][14]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[87][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][14]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][14]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][14]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][14]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][15]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][15]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][15]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[4][15]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][15]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][15]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[37][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[42][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[82][15]={0,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[83][15]={1,1,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[85][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][15]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][15]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[101][15]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[102][15]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[103][15]={2,2,4,2,{{1,2},{1,0},{1,1}},{21,1}}
 MapToConvert[104][15]={0,2,2,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][15]={0,2,2,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[2][16]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][16]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[4][16]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][16]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][16]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][16]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][16]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][16]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[13][16]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[35][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[41][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][16]={0,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[83][16]={1,1,5,3,{{1,2},{0,-1},{0,-1}},{18,1}}
 MapToConvert[84][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][16]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][16]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[100][16]={2,2,4,2,{{1,2},{0,-1},{1,1}},{21,1}}
 MapToConvert[101][16]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[104][16]={2,2,4,2,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[105][16]={0,2,2,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[106][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[0][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][17]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][17]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][17]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{8,1}}
 MapToConvert[5][17]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][17]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[7][17]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][17]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][17]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[10][17]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][17]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][17]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][17]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][17]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[18][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][17]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][17]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][17]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][17]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[38][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][17]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][17]={1,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[84][17]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[87][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][17]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][17]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][17]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][17]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[99][17]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][17]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][17]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[102][17]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][17]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][17]={2,2,4,2,{{0,-1},{1,3},{1,4}},{21,1}}
 MapToConvert[105][17]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][17]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][17]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[0][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][18]={0,2,-1,3,{{1,5},{0,-1},{1,4}},{34,1}}
 MapToConvert[4][18]={0,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[5][18]={1,1,-1,3,{{1,5},{0,-1},{1,4}},{18,1}}
 MapToConvert[6][18]={1,2,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[7][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][18]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][18]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][18]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][18]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][18]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][18]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[20][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[23][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[28][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[33][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][18]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][18]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[61][18]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][18]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][18]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][18]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][18]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][18]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[79][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][18]={0,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[83][18]={0,1,-1,3,{{1,5},{0,-1},{1,4}},{18,1}}
 MapToConvert[84][18]={1,1,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][18]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[88][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[92][18]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][18]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][18]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][18]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[97][18]={2,2,4,2,{{1,2},{0,-1},{1,1}},{21,1}}
 MapToConvert[98][18]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[99][18]={2,2,4,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[100][18]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[101][18]={2,2,4,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[102][18]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[103][18]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{8,1}}
 MapToConvert[104][18]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[105][18]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{3,4}}
 MapToConvert[106][18]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[107][18]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[0][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][19]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][19]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][19]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][19]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[9][19]={1,1,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[10][19]={1,0,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[11][19]={1,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[12][19]={1,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[13][19]={1,0,-1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[14][19]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][19]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][19]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][19]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][19]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][19]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][19]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][19]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][19]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][19]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][19]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[28][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][19]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][19]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][19]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[35][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][19]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][19]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][19]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[77][19]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][19]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[82][19]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[83][19]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][19]={0,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[86][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][19]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[89][19]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][19]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[93][19]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[94][19]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[95][19]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[96][19]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][19]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][19]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[99][19]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{21,1}}
 MapToConvert[100][19]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][19]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[102][19]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][19]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{23,1}}
 MapToConvert[107][19]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[4][20]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][20]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][20]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][20]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[8][20]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{1,4}}
 MapToConvert[9][20]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][20]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{2,1}}
 MapToConvert[15][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[16][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][20]={1,1,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[18][20]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][20]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][20]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[31][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[33][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][20]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[37][20]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][20]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][20]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[59][20]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[62][20]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][20]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[83][20]={1,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][20]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][20]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][20]={1,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][20]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[88][20]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][20]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[92][20]={0,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[93][20]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[94][20]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[96][20]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][20]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[98][20]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[99][20]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][20]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[104][20]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][20]={0,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[107][20]={0,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][21]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{6,1}}
 MapToConvert[7][21]={1,1,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][21]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[10][21]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][21]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[13][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][21]={1,2,-1,3,{{0,-1},{0,-1},{1,1}},{2,3}}
 MapToConvert[18][21]={1,0,-1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[19][21]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][21]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][21]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[25][21]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][21]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[29][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][21]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[32][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][21]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{1,4}}
 MapToConvert[34][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[37][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][21]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][21]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{34,1}}
 MapToConvert[58][21]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{8,1}}
 MapToConvert[59][21]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][21]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][21]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][21]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][21]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][21]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][21]={0,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[87][21]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[88][21]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[89][21]={0,2,5,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[90][21]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[91][21]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[92][21]={1,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[94][21]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][21]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[97][21]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][21]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][21]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[102][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][21]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[105][21]={0,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[106][21]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][21]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][22]={0,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[7][22]={0,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][22]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[9][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][22]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][22]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][22]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][22]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[17][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][22]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][22]={1,0,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[20][22]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[22][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][22]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[24][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[27][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][22]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][22]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][22]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][22]={1,1,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[35][22]={1,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[36][22]={0,1,5,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[37][22]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][22]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[39][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[40][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][22]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[44][22]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[45][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[57][22]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][22]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][22]={1,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][22]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][22]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][22]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][22]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][22]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][22]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[74][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][22]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][22]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][22]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][22]={1,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[81][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][22]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][22]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][22]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][22]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][22]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[89][22]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[90][22]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[91][22]={1,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][22]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[94][22]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][22]={1,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[96][22]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[97][22]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][22]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[101][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][22]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][22]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][22]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][22]={0,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[106][22]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][22]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][23]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][23]={1,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[14][23]={1,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[15][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][23]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][23]={0,1,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[20][23]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][23]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][23]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][23]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[24][23]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][23]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][23]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][23]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][23]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][23]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[31][23]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{0,3}}
 MapToConvert[32][23]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[34][23]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][23]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{6,1}}
 MapToConvert[37][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][23]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][23]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][23]={1,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[43][23]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[44][23]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][23]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[57][23]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][23]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[59][23]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][23]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[61][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][23]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[63][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][23]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][23]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[67][23]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][23]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][23]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[70][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[72][23]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[73][23]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][23]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][23]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][23]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][23]={1,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[79][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][23]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[81][23]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[83][23]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][23]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][23]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][23]={0,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[87][23]={0,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[88][23]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[89][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][23]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[91][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][23]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][23]={0,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[95][23]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][23]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[99][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][23]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][23]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][23]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][23]={1,1,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[106][23]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[107][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[9][24]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[12][24]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][24]={0,2,-1,3,{{0,-1},{1,0},{0,-1}},{6,1}}
 MapToConvert[14][24]={1,1,-1,3,{{1,5},{0,-1},{0,-1}},{18,1}}
 MapToConvert[15][24]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][24]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[18][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[19][24]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][24]={0,1,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[21][24]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][24]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[23][24]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][24]={1,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[25][24]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[26][24]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][24]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][24]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][24]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][24]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][24]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[33][24]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][24]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][24]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][24]={0,1,-1,3,{{0,-1},{0,-1},{1,1}},{34,1}}
 MapToConvert[38][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[39][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][24]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[42][24]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[43][24]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][24]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][24]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][24]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][24]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][24]={0,1,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[68][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[69][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][24]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][24]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][24]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][24]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[77][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[79][24]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[80][24]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][24]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{25,1}}
 MapToConvert[82][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][24]={0,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[86][24]={0,1,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][24]={1,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][24]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][24]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][24]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][24]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][24]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[95][24]={0,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][24]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[97][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][24]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][24]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[104][24]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][24]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][24]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][25]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][25]={1,2,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[14][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[15][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][25]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][25]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][25]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[20][25]={1,1,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[21][25]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][25]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[23][25]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][25]={1,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[25][25]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][25]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][25]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[28][25]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][25]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][25]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][25]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][25]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[33][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[44][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][25]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][25]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][25]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][25]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][25]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][25]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][25]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][25]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][25]={0,1,5,2,{{0,-1},{0,-1},{1,4}},{18,1}}
 MapToConvert[68][25]={1,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[69][25]={1,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[70][25]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][25]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[74][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[76][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][25]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][25]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][25]={1,0,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[80][25]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][25]={1,1,5,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[82][25]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][25]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][25]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][25]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{8,1}}
 MapToConvert[86][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][25]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][25]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][25]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[93][25]={1,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[94][25]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][25]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[96][25]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][25]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][25]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][25]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][25]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][25]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][25]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][26]={0,2,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[14][26]={0,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[16][26]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[19][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][26]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[22][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][26]={0,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[25][26]={0,2,-1,3,{{1,5},{0,-1},{0,-1}},{27,1}}
 MapToConvert[26][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][26]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][26]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][26]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[33][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][26]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[49][26]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][26]={0,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[57][26]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][26]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[59][26]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[60][26]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[62][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][26]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][26]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{26,1}}
 MapToConvert[67][26]={0,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[68][26]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][26]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[72][26]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][26]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][26]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][26]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][26]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[79][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][26]={1,1,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[81][26]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][26]={1,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][26]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][26]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[87][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][26]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[90][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][26]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[93][26]={0,1,5,2,{{1,2},{0,-1},{1,1}},{12,1}}
 MapToConvert[94][26]={1,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][26]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[100][26]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[101][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][26]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][26]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[106][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[107][26]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][27]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][27]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[17][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[20][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[23][27]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][27]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[25][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][27]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[27][27]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][27]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[29][27]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[47][27]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][27]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[55][27]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][27]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{8,1}}
 MapToConvert[57][27]={0,1,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[58][27]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][27]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[60][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][27]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][27]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][27]={0,2,-1,2,{{0,-1},{0,-1},{1,4}},{25,1}}
 MapToConvert[68][27]={0,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[69][27]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{8,1}}
 MapToConvert[70][27]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][27]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][27]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][27]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][27]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[75][27]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][27]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][27]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][27]={1,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[79][27]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[80][27]={1,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[81][27]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[82][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][27]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][27]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][27]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][27]={1,1,5,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[87][27]={0,1,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[88][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][27]={1,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[90][27]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[91][27]={0,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[92][27]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][27]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][27]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[97][27]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][27]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][27]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[100][27]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][27]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][27]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[104][27]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][27]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][27]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][27]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][28]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][28]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[29][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][28]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[49][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][28]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][28]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[56][28]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][28]={1,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[58][28]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][28]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][28]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][28]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][28]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][28]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[69][28]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][28]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][28]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][28]={1,1,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[73][28]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][28]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][28]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][28]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[77][28]={1,2,-1,4,{{0,-1},{1,0},{0,-1}},{1,4}}
 MapToConvert[78][28]={1,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[79][28]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][28]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][28]={1,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[82][28]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][28]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[84][28]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][28]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][28]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[87][28]={1,1,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[88][28]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][28]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][28]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][28]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][28]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[93][28]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][28]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][28]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][28]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[97][28]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][28]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][28]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][28]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][28]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[103][28]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][28]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][28]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][28]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[107][28]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][29]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[51][29]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][29]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[55][29]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][29]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][29]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][29]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[59][29]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{0,5}}
 MapToConvert[60][29]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][29]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][29]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[68][29]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][29]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[70][29]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][29]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[73][29]={1,1,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[74][29]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][29]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][29]={1,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[78][29]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[79][29]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[80][29]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][29]={0,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[82][29]={1,2,-1,4,{{1,5},{1,3},{1,4}},{31,1}}
 MapToConvert[83][29]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[85][29]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][29]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{25,1}}
 MapToConvert[87][29]={1,1,-1,4,{{1,5},{1,3},{1,4}},{18,1}}
 MapToConvert[88][29]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][29]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][29]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][29]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][29]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][29]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][29]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][29]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[101][29]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][29]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][29]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][29]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][29]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][29]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][30]={0,2,12,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[19][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][30]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][30]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][30]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[49][30]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][30]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][30]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][30]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[56][30]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[57][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][30]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][30]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][30]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[64][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][30]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][30]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][30]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[72][30]={1,1,5,4,{{1,5},{0,-1},{1,4}},{0,4}}
 MapToConvert[73][30]={1,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[74][30]={1,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][30]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][30]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[78][30]={1,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[79][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][30]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][30]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][30]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][30]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[84][30]={1,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[85][30]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][30]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][30]={1,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[88][30]={1,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][30]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][30]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][30]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][30]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][30]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][30]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][30]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][30]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[99][30]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][30]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][30]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][30]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][30]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][30]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][30]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][30]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[107][30]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[15][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][31]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][31]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[39][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][31]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][31]={1,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[48][31]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[50][31]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][31]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][31]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{6,1}}
 MapToConvert[56][31]={1,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][31]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][31]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[60][31]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][31]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][31]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][31]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][31]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[66][31]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][31]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[71][31]={1,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[72][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][31]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][31]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][31]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][31]={0,1,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[79][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][31]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[82][31]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][31]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][31]={1,0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[88][31]={1,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[89][31]={0,1,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[90][31]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][31]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][31]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][31]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][31]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[96][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][31]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][31]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][31]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][31]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[14][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[17][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][32]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[20][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[28][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[38][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[48][32]={1,1,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[49][32]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[50][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[55][32]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[59][32]={0,0,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[60][32]={0,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][32]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[62][32]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][32]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{25,1}}
 MapToConvert[65][32]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[66][32]={1,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[68][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][32]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[70][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[72][32]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{1,4}}
 MapToConvert[73][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[75][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][32]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[79][32]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{6,1}}
 MapToConvert[80][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][32]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][32]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][32]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[86][32]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[89][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][32]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[91][32]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[92][32]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[93][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[94][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][32]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][32]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][32]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][32]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[103][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[107][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[11][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][33]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{34,1}}
 MapToConvert[14][33]={1,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[15][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][33]={1,0,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[17][33]={1,0,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[18][33]={1,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[20][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][33]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][33]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[27][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[38][33]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[45][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[46][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][33]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][33]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][33]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[63][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][33]={0,1,-1,4,{{0,-1},{1,3},{1,4}},{18,1}}
 MapToConvert[65][33]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][33]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[72][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][33]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[77][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][33]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{2,2}}
 MapToConvert[79][33]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[80][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][33]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][33]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[97][33]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[98][33]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][33]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][33]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][34]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[14][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][34]={1,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[16][34]={1,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[17][34]={1,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[19][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][34]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[22][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][34]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][34]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[44][34]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[45][34]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][34]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[47][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[49][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][34]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][34]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[56][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][34]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][34]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][34]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[60][34]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][34]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][34]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][34]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][34]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[65][34]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][34]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[70][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][34]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[81][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][34]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][34]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[90][34]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][34]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][34]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][34]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][34]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[101][34]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[102][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][35]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][35]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[12][35]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][35]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[16][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[17][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][35]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][35]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[21][35]={1,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[22][35]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][35]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[39][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][35]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][35]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{7,1}}
 MapToConvert[45][35]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[47][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[48][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][35]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][35]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][35]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][35]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][35]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][35]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][35]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][35]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][35]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][35]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][35]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][35]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[86][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][35]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][35]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[94][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][35]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][35]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][35]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{25,1}}
 MapToConvert[98][35]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[99][35]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[100][35]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{3,2}}
 MapToConvert[101][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[10][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[11][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[14][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][36]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][36]={1,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[21][36]={1,1,-1,4,{{1,2},{0,-1},{0,-1}},{18,1}}
 MapToConvert[22][36]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][36]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[25][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][36]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[44][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][36]={0,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[46][36]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[47][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[52][36]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][36]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][36]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][36]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][36]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][36]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[59][36]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][36]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[65][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][36]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[68][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][36]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[91][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[92][36]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][36]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][36]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][36]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{17,1}}
 MapToConvert[97][36]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[98][36]={1,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][36]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][36]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][36]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][37]={1,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[11][37]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{6,1}}
 MapToConvert[12][37]={1,1,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[13][37]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][37]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][37]={1,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[17][37]={1,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[18][37]={1,1,-1,4,{{1,5},{1,3},{1,4}},{0,1}}
 MapToConvert[19][37]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][37]={1,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[21][37]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[22][37]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][37]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[26][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][37]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][37]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[40][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][37]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[45][37]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][37]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][37]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][37]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][37]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[54][37]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][37]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][37]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[59][37]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{7,1}}
 MapToConvert[60][37]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[61][37]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[62][37]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[63][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[64][37]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][37]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[88][37]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[89][37]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[90][37]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[91][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][37]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[93][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[95][37]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][37]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][37]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][37]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][37]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][37]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][37]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[11][38]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][38]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[14][38]={1,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[15][38]={0,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[16][38]={1,1,-1,4,{{1,5},{0,-1},{1,4}},{16,1}}
 MapToConvert[17][38]={1,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][38]={0,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[20][38]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[21][38]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][38]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][38]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{26,1}}
 MapToConvert[25][38]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[26][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[35][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[40][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[44][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[45][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][38]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][38]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[55][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][38]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[58][38]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[59][38]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[63][38]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[64][38]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[65][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][38]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][38]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][38]={0,1,5,4,{{0,-1},{0,-1},{1,4}},{12,1}}
 MapToConvert[92][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][38]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][38]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][38]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][38]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][38]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[102][38]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[13][39]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][39]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[15][39]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][39]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][39]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[20][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][39]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][39]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[24][39]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][39]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[27][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][39]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][39]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[51][39]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][39]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[53][39]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[54][39]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[55][39]={1,1,-1,4,{{1,2},{0,-1},{1,1}},{4,4}}
 MapToConvert[56][39]={1,2,-1,4,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[57][39]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][39]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][39]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][39]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][39]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][39]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{16,1}}
 MapToConvert[65][39]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[66][39]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[67][39]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][39]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][39]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][39]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][39]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][39]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][39]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][39]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][39]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][39]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][39]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[107][39]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][40]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[13][40]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][40]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][40]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[16][40]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[17][40]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{6,1}}
 MapToConvert[18][40]={1,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[19][40]={1,1,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[20][40]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][40]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[22][40]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][40]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[24][40]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][40]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][40]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[33][40]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][40]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][40]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][40]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[45][40]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][40]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][40]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][40]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[52][40]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[53][40]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][40]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][40]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[56][40]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[57][40]={1,2,-1,4,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[58][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][40]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][40]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][40]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][40]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[68][40]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[69][40]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[71][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][40]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[78][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][40]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][40]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][40]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][40]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][40]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][40]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][40]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][40]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][40]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][40]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][40]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[98][40]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][40]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[100][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[101][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][40]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][41]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][41]={1,1,5,4,{{0,-1},{1,0},{0,-1}},{0,3}}
 MapToConvert[14][41]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{1,3}}
 MapToConvert[15][41]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][41]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][41]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][41]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][41]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][41]={1,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[23][41]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[25][41]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][41]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][41]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][41]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][41]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[33][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][41]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[38][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][41]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][41]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][41]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[45][41]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[46][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[47][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][41]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][41]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{2,4}}
 MapToConvert[50][41]={0,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[51][41]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][41]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][41]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[56][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][41]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{5,2}}
 MapToConvert[58][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[61][41]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[63][41]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[65][41]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][41]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][41]={0,1,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[68][41]={0,2,-1,4,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[69][41]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][41]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][41]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][41]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][41]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][41]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][41]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][41]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][41]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][41]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][41]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][41]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][41]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][41]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][41]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][41]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][41]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[13][42]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[14][42]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][42]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[19][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][42]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][42]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{26,1}}
 MapToConvert[23][42]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][42]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][42]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][42]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][42]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][42]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][42]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][42]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[34][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[35][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][42]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[37][42]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][42]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[43][42]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[44][42]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[45][42]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[48][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][42]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[54][42]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[55][42]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[56][42]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[58][42]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[59][42]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[66][42]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[69][42]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[70][42]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[77][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[82][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][42]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][42]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][42]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][42]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[93][42]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][42]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][42]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[97][42]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[98][42]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][42]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][42]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[14][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[17][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[20][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][43]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[22][43]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][43]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][43]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[27][43]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[28][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][43]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[32][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][43]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[34][43]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[35][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][43]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[40][43]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[41][43]={1,2,5,4,{{1,2},{0,-1},{1,1}},{9,1}}
 MapToConvert[42][43]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[43][43]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[46][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[47][43]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][43]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[52][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][43]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[55][43]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][43]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[58][43]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[63][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][43]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[67][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][43]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][43]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[71][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[72][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][43]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][43]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[84][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][43]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[88][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[89][43]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][43]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][43]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][43]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][43]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][43]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][43]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][44]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[14][44]={0,2,-1,4,{{1,5},{1,3},{1,4}},{7,1}}
 MapToConvert[15][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[18][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[19][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][44]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][44]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][44]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][44]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[27][44]={1,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[28][44]={1,2,-1,4,{{1,5},{0,-1},{0,-1}},{6,1}}
 MapToConvert[29][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[32][44]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[33][44]={1,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[34][44]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][44]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][44]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][44]={0,0,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[39][44]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[40][44]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{17,1}}
 MapToConvert[41][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][44]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][44]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][44]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][44]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][44]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[50][44]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][44]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{6,1}}
 MapToConvert[56][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[57][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][44]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[59][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[61][44]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][44]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][44]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][44]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][44]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[70][44]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[71][44]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][44]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[75][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][44]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][44]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][44]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][44]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][44]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][44]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[93][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][44]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][44]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[97][44]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[106][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][44]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[20][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[26][45]={1,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[27][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[30][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][45]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][45]={1,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[33][45]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[37][45]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][45]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][45]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][45]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[43][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[44][45]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[46][45]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[52][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][45]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{1,5}}
 MapToConvert[55][45]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][45]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[59][45]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[64][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][45]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][45]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[68][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][45]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[70][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][45]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{6,1}}
 MapToConvert[75][45]={1,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[76][45]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[77][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[80][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[81][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[85][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[87][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][45]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[96][45]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][45]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[104][45]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][45]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][45]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][45]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][46]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[17][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][46]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[26][46]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{3,4}}
 MapToConvert[27][46]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][46]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][46]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][46]={1,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[34][46]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][46]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][46]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][46]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][46]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][46]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][46]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][46]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][46]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][46]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][46]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[48][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[49][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[51][46]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[52][46]={0,2,5,4,{{1,2},{0,-1},{1,1}},{33,1}}
 MapToConvert[53][46]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[54][46]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[55][46]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][46]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][46]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][46]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][46]={0,2,5,4,{{1,5},{0,-1},{1,4}},{4,4}}
 MapToConvert[61][46]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][46]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][46]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][46]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[68][46]={0,1,5,4,{{1,2},{0,-1},{1,1}},{2,1}}
 MapToConvert[69][46]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[70][46]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[72][46]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,1}}
 MapToConvert[77][46]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[78][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][46]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[83][46]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[84][46]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][46]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][46]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][46]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][46]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[25][47]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[27][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[31][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][47]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{6,1}}
 MapToConvert[33][47]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[34][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[36][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[39][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[43][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][47]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][47]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][47]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][47]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][47]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[49][47]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[50][47]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[51][47]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][47]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[56][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[57][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{4,2}}
 MapToConvert[61][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][47]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][47]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[66][47]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[67][47]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{2,4}}
 MapToConvert[68][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][47]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[74][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[76][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][47]={1,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[78][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[79][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][47]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{4,2}}
 MapToConvert[81][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][47]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][47]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{6,1}}
 MapToConvert[84][47]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[85][47]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][47]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[91][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[93][47]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][47]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][47]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{1,2}}
 MapToConvert[96][47]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][47]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[105][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][48]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][48]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][48]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[33][48]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][48]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[35][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][48]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][48]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][48]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[46][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][48]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[48][48]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[49][48]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[51][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[54][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][48]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][48]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][48]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][48]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][48]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][48]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][48]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[66][48]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[67][48]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][48]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[71][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[73][48]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][48]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][48]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][48]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][48]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[78][48]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][48]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][48]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[82][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][48]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[86][48]={1,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[87][48]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][48]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][48]={1,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[95][48]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[96][48]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[98][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[105][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][48]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[27][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[29][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][49]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[32][49]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[34][49]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[35][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[36][49]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][49]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[38][49]={0,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][49]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[40][49]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][49]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{9,1}}
 MapToConvert[47][49]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][49]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[52][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][49]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][49]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][49]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][49]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[58][49]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[61][49]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][49]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][49]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[68][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][49]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[75][49]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[78][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[81][49]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][49]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[87][49]={0,2,-1,4,{{1,5},{1,3},{1,4}},{1,1}}
 MapToConvert[88][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[89][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][49]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][49]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[95][49]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][49]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][49]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][49]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][49]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][50]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[28][50]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[29][50]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[30][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][50]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[32][50]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{1,4}}
 MapToConvert[33][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][50]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[35][50]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{0,4}}
 MapToConvert[36][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][50]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{6,1}}
 MapToConvert[39][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][50]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[41][50]={0,1,5,4,{{1,2},{1,0},{1,1}},{12,1}}
 MapToConvert[42][50]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][50]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,2}}
 MapToConvert[45][50]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][50]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[47][50]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][50]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][50]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][50]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[56][50]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][50]={0,1,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[58][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[65][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][50]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][50]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[72][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][50]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{4,5}}
 MapToConvert[74][50]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[75][50]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[80][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[85][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][50]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[89][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][50]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][50]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][50]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][50]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[94][50]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[95][50]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[96][50]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[97][50]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[98][50]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[103][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][50]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][50]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[25][51]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[26][51]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[27][51]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{7,1}}
 MapToConvert[28][51]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][51]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[30][51]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[31][51]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[33][51]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][51]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[35][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][51]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[38][51]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[39][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[40][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][51]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[42][51]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{7,1}}
 MapToConvert[43][51]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[44][51]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[45][51]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][51]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][51]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[48][51]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{6,1}}
 MapToConvert[49][51]={0,1,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][51]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[51][51]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[52][51]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][51]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[55][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][51]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[57][51]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[58][51]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[59][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[62][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][51]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][51]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[72][51]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][51]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[77][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][51]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][51]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[89][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[92][51]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[93][51]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][51]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[98][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][51]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][51]={0,2,5,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[104][51]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][51]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][51]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][51]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[0][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][52]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[26][52]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[30][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][52]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[32][52]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[33][52]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{7,1}}
 MapToConvert[34][52]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[35][52]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][52]={0,1,-1,4,{{0,-1},{1,0},{1,1}},{26,1}}
 MapToConvert[40][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][52]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][52]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[48][52]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[49][52]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][52]={0,1,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[51][52]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[55][52]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][52]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[59][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[61][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][52]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][52]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][52]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[81][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][52]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][52]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[88][52]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[89][52]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[91][52]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[92][52]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[93][52]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[96][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][52]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[101][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][52]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{6,1}}
 MapToConvert[105][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][52]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][52]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][53]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[27][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][53]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][53]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[32][53]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[35][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][53]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[39][53]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[40][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][53]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[43][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][53]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][53]={0,1,-1,1,{{0,-1},{1,0},{1,1}},{8,1}}
 MapToConvert[49][53]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][53]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[51][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[53][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][53]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[59][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[65][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][53]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][53]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][53]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][53]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][53]={0,2,2,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[72][53]={0,2,5,4,{{1,2},{1,3},{1,4}},{9,1}}
 MapToConvert[73][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[74][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][53]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][53]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[84][53]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[85][53]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[86][53]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][53]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][53]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[92][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[97][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][53]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[101][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][53]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][53]={1,1,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[105][53]={0,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[106][53]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][54]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[26][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][54]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[30][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][54]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{9,1}}
 MapToConvert[32][54]={0,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][54]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[37][54]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[38][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][54]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][54]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[41][54]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[42][54]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[43][54]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{6,1}}
 MapToConvert[44][54]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[45][54]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[46][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][54]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[48][54]={0,1,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[49][54]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][54]={0,1,-1,1,{{0,-1},{1,0},{1,1}},{4,5}}
 MapToConvert[52][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][54]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[58][54]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{12,1}}
 MapToConvert[59][54]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[61][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][54]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[64][54]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[67][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][54]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[70][54]={0,2,2,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[71][54]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[72][54]={0,2,5,4,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][54]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][54]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[83][54]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[84][54]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][54]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][54]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[90][54]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[91][54]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[92][54]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][54]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][54]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[100][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[101][54]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[102][54]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][54]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][54]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][54]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[106][54]={0,2,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[107][54]={0,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[0][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][55]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][55]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][55]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[35][55]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{2,3}}
 MapToConvert[36][55]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][55]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[38][55]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][55]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[40][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][55]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[42][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][55]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[45][55]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[46][55]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[47][55]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[49][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][55]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[51][55]={1,2,-1,4,{{1,5},{0,-1},{0,-1}},{3,2}}
 MapToConvert[52][55]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][55]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[54][55]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[55][55]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[56][55]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[57][55]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][55]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[59][55]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[60][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][55]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[62][55]={0,2,2,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[63][55]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{0,4}}
 MapToConvert[64][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][55]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][55]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][55]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[68][55]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[69][55]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[70][55]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][55]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[73][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][55]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][55]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{3,4}}
 MapToConvert[81][55]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][55]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[84][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][55]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[89][55]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][55]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][55]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[102][55]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][55]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][55]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[106][55]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][55]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[0][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[32][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[34][56]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{2,2}}
 MapToConvert[35][56]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[36][56]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[38][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][56]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][56]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[42][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][56]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[44][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][56]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[46][56]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][56]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[50][56]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[51][56]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][56]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][56]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[55][56]={0,2,5,4,{{1,5},{0,-1},{1,4}},{9,1}}
 MapToConvert[56][56]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[60][56]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][56]={0,2,2,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][56]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][56]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][56]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][56]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[66][56]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[67][56]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[68][56]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][56]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][56]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[72][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][56]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[74][56]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[75][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][56]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[81][56]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][56]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[89][56]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[91][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][56]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][56]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][56]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[102][56]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][56]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][56]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[105][56]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][56]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][56]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][57]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[34][57]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[36][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][57]={0,2,2,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[38][57]={0,2,5,4,{{1,2},{1,0},{1,1}},{33,1}}
 MapToConvert[39][57]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[42][57]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[43][57]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[45][57]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[46][57]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[47][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[48][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][57]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[50][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[51][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][57]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[55][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][57]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][57]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][57]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][57]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][57]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][57]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][57]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][57]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[73][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][57]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{2,5}}
 MapToConvert[75][57]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][57]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[78][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][57]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[80][57]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[87][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][57]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[89][57]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[90][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[92][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][57]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][57]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][57]={1,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[102][57]={1,1,-1,2,{{1,5},{1,3},{1,4}},{16,1}}
 MapToConvert[103][57]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][57]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][57]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][57]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][57]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[27][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][58]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][58]={0,2,2,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[37][58]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[38][58]={0,2,2,4,{{1,2},{1,0},{0,-1}},{-1,0}}
 MapToConvert[39][58]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{1,4}}
 MapToConvert[40][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[42][58]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[43][58]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][58]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[46][58]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[47][58]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[49][58]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[50][58]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[54][58]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[55][58]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[57][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][58]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][58]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[65][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][58]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[68][58]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][58]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][58]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[91][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][58]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][58]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][58]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][58]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][58]={1,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[104][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[105][58]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][58]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[107][58]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[24][59]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[25][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[31][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][59]={0,2,-1,4,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[37][59]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[38][59]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[41][59]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{3,3}}
 MapToConvert[42][59]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][59]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[45][59]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[47][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][59]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[50][59]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[51][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[52][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[54][59]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[55][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[58][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[60][59]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[61][59]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][59]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][59]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][59]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[74][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[79][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[82][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[84][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][59]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[91][59]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[92][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][59]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[98][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[101][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[102][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][59]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[104][59]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[105][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][59]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][60]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[28][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[30][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[33][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[37][60]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][60]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[42][60]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][60]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{33,1}}
 MapToConvert[44][60]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{6,1}}
 MapToConvert[45][60]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[47][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][60]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[50][60]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][60]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[56][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][60]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[60][60]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][60]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[63][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][60]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[72][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[88][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][60]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[92][60]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[98][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][60]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[105][60]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][61]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[28][61]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[29][61]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[30][61]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[31][61]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][61]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][61]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][61]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[41][61]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[42][61]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[43][61]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[50][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][61]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[58][61]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{12,1}}
 MapToConvert[59][61]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[62][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[66][61]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[68][61]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[77][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][61]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[81][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][61]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[92][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[96][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[100][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][61]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][61]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][61]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[105][61]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[106][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][62]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[26][62]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[27][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][62]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{9,1}}
 MapToConvert[29][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][62]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[38][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[40][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[43][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[46][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[48][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[58][62]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][62]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][62]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][62]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[75][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[78][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[80][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[84][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][62]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[92][62]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[94][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][62]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[102][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][62]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][62]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[106][62]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[18][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,1}}
 MapToConvert[21][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][63]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[26][63]={0,1,5,4,{{0,-1},{1,3},{1,4}},{0,4}}
 MapToConvert[27][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[30][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][63]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][63]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[43][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][63]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[48][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[59][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][63]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{9,1}}
 MapToConvert[64][63]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[65][63]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][63]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[86][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[89][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][63]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[92][63]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[93][63]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[94][63]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{6,1}}
 MapToConvert[95][63]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[96][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][63]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][63]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[106][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][64]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[21][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][64]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{16,1}}
 MapToConvert[27][64]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[29][64]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[30][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][64]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[45][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[61][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][64]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[63][64]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[64][64]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][64]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][64]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[74][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[78][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[80][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][64]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[91][64]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[92][64]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][64]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{7,1}}
 MapToConvert[97][64]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[98][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][64]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][64]={0,2,5,4,{{0,-1},{1,3},{1,4}},{9,1}}
 MapToConvert[107][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][65]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,1}}
 MapToConvert[18][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[20][65]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[21][65]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][65]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[30][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[31][65]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][65]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[46][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[48][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][65]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[53][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][65]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][65]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{4,5}}
 MapToConvert[62][65]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][65]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[67][65]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[71][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[75][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[83][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[89][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][65]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[91][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][65]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[98][65]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[99][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][65]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][65]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[107][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][66]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[18][66]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{8,1}}
 MapToConvert[19][66]={0,2,-1,4,{{1,5},{1,3},{1,4}},{30,1}}
 MapToConvert[20][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][66]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{0,2}}
 MapToConvert[22][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[24][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[28][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][66]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[30][66]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[31][66]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[32][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[45][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[46][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][66]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{7,1}}
 MapToConvert[50][66]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[51][66]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[61][66]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][66]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{0,2}}
 MapToConvert[63][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[65][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][66]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][66]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][66]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][66]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[74][66]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[75][66]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[76][66]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[77][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[79][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[82][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][66]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][66]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[87][66]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][66]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][66]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][66]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[91][66]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][66]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[100][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[102][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][66]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[0][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][67]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[20][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[22][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[23][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][67]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[30][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[32][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[44][67]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[45][67]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[46][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][67]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[50][67]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[51][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[53][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][67]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][67]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][67]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][67]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[69][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][67]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][67]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][67]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][67]={0,1,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][67]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[78][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[79][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[80][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][67]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][67]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[85][67]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[86][67]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][67]={1,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[88][67]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][67]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[90][67]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][67]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[100][67]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][67]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][67]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[0][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[20][68]={0,2,5,4,{{0,-1},{1,3},{1,4}},{9,1}}
 MapToConvert[21][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][68]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[30][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[46][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][68]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[49][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[50][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[60][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[63][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][68]={0,2,2,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[71][68]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[72][68]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{5,4}}
 MapToConvert[73][68]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][68]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][68]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][68]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[78][68]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][68]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][68]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][68]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][68]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][68]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[84][68]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[85][68]={1,1,5,4,{{1,2},{0,-1},{0,-1}},{4,3}}
 MapToConvert[86][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[88][68]={1,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[89][68]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[90][68]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[99][68]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[100][68]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][68]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][68]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][69]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[21][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[32][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][69]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[49][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[51][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][69]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[70][69]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][69]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][69]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[76][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][69]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[79][69]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[80][69]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[81][69]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][69]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[83][69]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[85][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[95][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][69]={0,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[100][69]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{15,1}}
 MapToConvert[101][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[106][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[19][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[21][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[23][70]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[24][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[29][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][70]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[50][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[67][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][70]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[69][70]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[70][70]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][70]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[83][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][70]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][70]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][70]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][70]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][70]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][70]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][71]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[23][71]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[27][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[30][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[41][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][71]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[43][71]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[44][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[48][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[53][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[56][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][71]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[66][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[67][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[70][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][71]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][71]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][71]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][71]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[87][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[91][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][71]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][71]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[24][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[29][72]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[30][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[31][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][72]={3,1,-1,4,{{0,-1},{1,3},{1,4}},{4,1}}
 MapToConvert[45][72]={3,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[50][72]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[52][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][72]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[55][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[65][72]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[66][72]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[67][72]={0,2,-1,4,{{1,5},{1,3},{1,4}},{6,1}}
 MapToConvert[68][72]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][72]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][72]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{8,1}}
 MapToConvert[77][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][72]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[79][72]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[80][72]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[81][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][72]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][72]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[103][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[107][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][73]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[43][73]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][73]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[45][73]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[47][73]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[48][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][73]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[51][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][73]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[53][73]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[54][73]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[55][73]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[58][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[69][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][73]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[73][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][73]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[77][73]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[78][73]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][73]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[81][73]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[82][73]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[83][73]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[84][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[95][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][73]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][74]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[27][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[28][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[29][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[31][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[42][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][74]={0,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[44][74]={3,0,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[45][74]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][74]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][74]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{20,1}}
 MapToConvert[48][74]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][74]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[50][74]={0,1,5,4,{{1,2},{0,-1},{1,1}},{20,1}}
 MapToConvert[51][74]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][74]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[53][74]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[55][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[61][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[64][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][74]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][74]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[71][74]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][74]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][74]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[75][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][74]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[85][74]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[86][74]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[87][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[90][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][74]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[100][74]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][74]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][75]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[27][75]={0,1,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[28][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[32][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[42][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][75]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][75]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][75]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][75]={3,0,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[48][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[50][75]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][75]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[52][75]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][75]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][75]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[71][75]={0,2,2,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[72][75]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][75]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[86][75]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[87][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[90][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[95][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][75]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][75]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][75]={0,1,5,4,{{1,2},{1,0},{1,1}},{12,1}}
 MapToConvert[102][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][75]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[26][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][76]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][76]={3,1,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[29][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][76]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[43][76]={0,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[44][76]={3,0,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[45][76]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[46][76]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][76]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[48][76]={3,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[49][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][76]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][76]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[55][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[60][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[63][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][76]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][76]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][76]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[72][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][76]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[80][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[82][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[84][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][76]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[86][76]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][76]={0,2,5,4,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[88][76]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[89][76]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[90][76]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[91][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,1}}
 MapToConvert[101][76]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][76]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[103][76]={0,1,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[104][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[107][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][77]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{9,1}}
 MapToConvert[26][77]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][77]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[28][77]={3,1,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[29][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[43][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][77]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[45][77]={3,0,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[46][77]={3,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][77]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][77]={3,1,-1,4,{{0,-1},{1,3},{1,4}},{2,4}}
 MapToConvert[49][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][77]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[52][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][77]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[64][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[66][77]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[73][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[75][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][77]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[79][77]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][77]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[85][77]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[89][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][77]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[91][77]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[92][77]={0,1,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[93][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[97][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][77]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][77]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][77]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][77]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[104][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][78]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][78]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][78]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[29][78]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][78]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[44][78]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[45][78]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][78]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][78]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[49][78]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][78]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[53][78]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[54][78]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[61][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][78]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[69][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[71][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][78]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[78][78]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[79][78]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][78]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[85][78]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][78]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[93][78]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][78]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][78]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][78]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][78]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[105][78]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[106][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][79]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][79]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][79]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[46][79]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[47][79]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][79]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][79]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][79]={3,0,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][79]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[52][79]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[54][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[75][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][79]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[78][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[80][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][79]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{3,3}}
 MapToConvert[85][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[87][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][79]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[93][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[98][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][79]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][79]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[106][79]={3,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[107][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[29][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][80]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[46][80]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[47][80]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][80]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[49][80]={3,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[50][80]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[57][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][80]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[65][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][80]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][80]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[76][80]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[77][80]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[78][80]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[87][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][80]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[93][80]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[94][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][80]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[98][80]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][80]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][80]={3,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[0][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][81]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[36][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][81]={0,2,5,4,{{0,-1},{1,0},{1,1}},{33,1}}
 MapToConvert[49][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][81]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][81]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][81]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[56][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][81]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[68][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[73][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][81]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[75][81]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[78][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[81][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][81]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[93][81]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[94][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][81]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][81]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][81]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[102][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][81]={3,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[0][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][82]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[49][82]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][82]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][82]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[52][82]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[53][82]={0,1,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[54][82]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{20,1}}
 MapToConvert[55][82]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[56][82]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][82]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[62][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][82]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[65][82]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][82]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][82]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[68][82]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][82]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][82]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[73][82]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[74][82]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[75][82]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][82]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[84][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[92][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][82]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[95][82]={0,1,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[96][82]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][82]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][82]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][82]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][82]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][82]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[106][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][82]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[0][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[49][83]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][83]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[51][83]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][83]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][83]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[54][83]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{30,1}}
 MapToConvert[55][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][83]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][83]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][83]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][83]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[69][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][83]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][83]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[78][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][83]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{20,1}}
 MapToConvert[83][83]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[88][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][83]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][83]={3,0,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[96][83]={3,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][83]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][83]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[100][83]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][83]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[107][83]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][84]={3,0,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[52][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][84]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][84]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[57][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][84]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[59][84]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][84]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][84]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][84]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][84]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][84]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][84]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[83][84]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][84]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[91][84]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[92][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][84]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][84]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][84]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[106][84]={3,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[107][84]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][85]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][85]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][85]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[52][85]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[53][85]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][85]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[55][85]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[56][85]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[57][85]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[58][85]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[62][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][85]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[66][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[69][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][85]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[72][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][85]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][85]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][85]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][85]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[81][85]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[82][85]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][85]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][85]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[90][85]={0,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[91][85]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][85]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][85]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[96][85]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][85]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[99][85]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][85]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[103][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][85]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[105][85]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][86]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][86]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[52][86]={3,0,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][86]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][86]={3,0,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[55][86]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][86]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{3,4}}
 MapToConvert[58][86]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][86]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[60][86]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][86]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[62][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][86]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][86]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][86]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][86]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][86]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[80][86]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[81][86]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][86]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][86]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][86]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[90][86]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[91][86]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][86]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][86]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][86]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][86]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][86]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][86]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[104][86]={3,2,5,4,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[105][86]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][86]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][87]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][87]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][87]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][87]={3,0,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[54][87]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[55][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][87]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][87]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][87]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[59][87]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{9,1}}
 MapToConvert[60][87]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[61][87]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][87]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][87]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][87]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[65][87]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[66][87]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][87]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][87]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][87]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][87]={3,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[79][87]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][87]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][87]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[83][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][87]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[89][87]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][87]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[96][87]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][87]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[103][87]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][87]={0,2,2,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[105][87]={3,1,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[106][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][87]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][88]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][88]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[11][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][88]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][88]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][88]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[30][88]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][88]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][88]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[53][88]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][88]={3,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[55][88]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][88]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][88]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][88]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[59][88]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][88]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[61][88]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][88]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][88]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][88]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][88]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][88]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][88]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[79][88]={3,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[80][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][88]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[89][88]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[92][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][88]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][88]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][88]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][88]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][88]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[99][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][88]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][88]={3,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[102][88]={3,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[103][88]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][88]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][88]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][88]={3,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[107][88]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][89]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][89]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[13][89]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][89]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][89]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][89]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][89]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][89]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][89]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][89]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][89]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][89]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][89]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][89]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][89]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][89]={3,0,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[55][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][89]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[58][89]={3,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][89]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[60][89]={0,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][89]={0,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[62][89]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[63][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[73][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][89]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][89]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][89]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][89]={3,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[80][89]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[81][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[86][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][89]={3,2,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[89][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][89]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][89]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][89]={3,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[101][89]={3,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][89]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][89]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][89]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][89]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][89]={0,2,2,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[107][89]={0,2,2,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[0][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][90]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[11][90]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][90]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][90]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[14][90]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][90]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][90]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][90]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][90]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][90]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][90]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][90]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][90]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][90]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[55][90]={0,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][90]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[59][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][90]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][90]={3,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[63][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[66][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[69][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,1}}
 MapToConvert[70][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][90]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][90]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][90]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][90]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[88][90]={3,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[89][90]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][90]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][90]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][90]={3,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[100][90]={3,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[101][90]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][90]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][90]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][90]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][91]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][91]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][91]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][91]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][91]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][91]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][91]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[15][91]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[18][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][91]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[30][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][91]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][91]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][91]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][91]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][91]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[56][91]={3,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[57][91]={3,0,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][91]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][91]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][91]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][91]={3,1,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[63][91]={3,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][91]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][91]={3,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[69][91]={3,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][91]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][91]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][91]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][91]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[76][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][91]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][91]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][91]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][91]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[86][91]={3,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[87][91]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[92][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][91]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][91]={3,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[100][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][91]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][91]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][91]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][91]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][91]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][91]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][92]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][92]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][92]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][92]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[11][92]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][92]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][92]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][92]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][92]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][92]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][92]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][92]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][92]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][92]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][92]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][92]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][92]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][92]={3,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[56][92]={4,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][92]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][92]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][92]={3,0,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[60][92]={3,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][92]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][92]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][92]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][92]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][92]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[67][92]={3,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[68][92]={3,1,-1,4,{{1,5},{0,-1},{1,4}},{16,1}}
 MapToConvert[69][92]={3,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][92]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][92]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][92]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][92]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][92]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][92]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][92]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][92]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][92]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][92]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][92]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][92]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][92]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][92]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[86][92]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][92]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][92]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][92]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[99][92]={3,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[100][92]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][92]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][92]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][92]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][92]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][92]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][92]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][93]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][93]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][93]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][93]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][93]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][93]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[52][93]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][93]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[54][93]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][93]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[56][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][93]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][93]={4,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][93]={4,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][93]={4,1,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[61][93]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][93]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[63][93]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][93]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][93]={4,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][93]={3,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][93]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][93]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][93]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][93]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][93]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][93]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][93]={3,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[99][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[101][93]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][93]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][93]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][93]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][94]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[9][94]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][94]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][94]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][94]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][94]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][94]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[16][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][94]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][94]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][94]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][94]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][94]={4,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][94]={4,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][94]={4,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][94]={4,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[65][94]={4,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[66][94]={4,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][94]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[73][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][94]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][94]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][94]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][94]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][94]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[86][94]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][94]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][94]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[98][94]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[99][94]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][94]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][94]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][94]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][95]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][95]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][95]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][95]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][95]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][95]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][95]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[62][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][95]={4,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[65][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][95]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][95]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][95]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][95]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][95]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][95]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][95]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][95]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][95]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][95]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][95]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][95]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][95]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][95]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[95][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][95]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][95]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[98][95]={3,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][95]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[103][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][95]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][95]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][96]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][96]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][96]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][96]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][96]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][96]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][96]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][96]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][96]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][96]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][96]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][96]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][96]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][96]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[66][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][96]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][96]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][96]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][96]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][96]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][96]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][96]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][96]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][96]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][96]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][96]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][96]={3,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[98][96]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[100][96]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][96]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][96]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][97]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][97]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][97]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][97]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][97]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][97]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][97]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[93][97]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][97]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][97]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][97]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][97]={3,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[98][97]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][97]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][97]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][97]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][97]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][97]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][97]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][97]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][97]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][97]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
	

	
	return MapToConvert
end